<?php

/**
 * @file
 * Provides API and management functions for the webform validation rules.
 */

/**
 * Get a rule entry.
 *
 * @deprecated in webform_validation:7.x-1.18 and is removed from webform_validation:7.x-2.0. Use webform_validation_rule_load().
 * @see https://www.drupal.org/project/webform_validation/issues/3104320
 */
function webform_validation_get_rule($ruleid) {
  return webform_validation_rule_load($ruleid);
}

/**
 * Get an array of rules assigned to a webform node.
 *
 * @param int $nid
 *   The node ID.
 *
 * @return array
 *   The rules for a node keyed by their rule ID.
 *
 * @see webform_validation_get_node_rules_assoc()
 */
function webform_validation_get_node_rules($nid) {
  $rules = array();
  $result = db_query("SELECT ruleid, rulename, nid, validator, data, error_message, negate, weight FROM {webform_validation_rule} WHERE nid = :nid ORDER BY weight ASC, ruleid DESC", array(':nid' => $nid), array('fetch' => PDO::FETCH_ASSOC));
  foreach ($result as $rule) {
    $rule['components'] = webform_validation_get_rule_components($rule['ruleid'], $rule['nid']);
    $rule['negate'] = (bool) $rule['negate'];
    $rules[$rule['ruleid']] = $rule;
  }
  return $rules;
}

/**
 * Get an array of rules assigned to a webform node keyed by their rulename.
 *
 * @param int $nid
 *   The node ID.
 *
 * @return array
 *   The rules for a node keyed by their rulename.
 *
 * @see webform_validation_get_node_rules()
 */
function webform_validation_get_node_rules_assoc($nid) {
  $assoc_rules = array();
  if ($rules = webform_validation_get_node_rules($nid)) {
    foreach ($rules as $rule) {
      $components = array();
      foreach ($rule['components'] as $cid => $component) {
        $components[$cid] = $cid;
      }
      ksort($components);
      $rule['components'] = $components;
      $assoc_rules[$rule['rulename']] = $rule;
    }
    ksort($assoc_rules);
  }
  return $assoc_rules;
}

/**
 * Get an array of components linked to a rule.
 */
function webform_validation_get_rule_components($ruleid, $nid) {
  $cids = array();
  $components = array();
  $result = db_query("SELECT cid FROM {webform_validation_rule_components} WHERE ruleid = :ruleid", array(':ruleid' => $ruleid));
  foreach ($result as $row) {
    $cids[] = $row->cid;
  }

  if ($cids) {
    $all_components = webform_validation_get_all_components($nid);
    $all_component_keys = array_keys($all_components);
    foreach ($cids as $cid) {
      if (in_array($cid, $all_component_keys)) {
        $components[$cid] = $all_components[$cid];
      }
    }
  }
  return $components;
}

/**
 * Get info on all components that are available on a webform.
 */
function webform_validation_get_all_components($nid) {
  $components = array();
  $result = db_query("SELECT * FROM {webform_component} WHERE nid = :nid", array(':nid' => $nid), array('fetch' => PDO::FETCH_ASSOC));
  foreach ($result as $row) {
    $components[$row['cid']] = $row;
  }
  return $components;
}

/**
 * Create basic version of component info.
 *
 * This helper function takes a list of full component info arrays and returns a
 * basic representation of it for output purposes.
 */
function webform_validation_rule_components_basic($components) {
  $ret = array();
  if ($components) {
    foreach ($components as $cid => $component) {
      $ret[$cid] = _webform_filter_xss($component['name']);
    }
  }
  return $ret;
}

/**
 * Delete a rule and dependencies.
 *
 * @param int $ruleid
 *   The ruleid of the rule to delete.
 */
function webform_dynamic_delete_rule($ruleid) {
  $transaction = db_transaction();
  // Delete rule.
  db_delete('webform_validation_rule')
    ->condition('ruleid', $ruleid)
    ->execute();
  // Delete rule components.
  db_delete('webform_validation_rule_components')
    ->condition('ruleid', $ruleid)
    ->execute();
}
