<?php
global $theme_root;
// get image
if (isset($node->field_image['und'])) {
    $image = image_style_url('blog_preview',$node->field_image['und'][0]['uri']);
} else {
    $image = $theme_root . '/images/defaults/img_blogs.png';
}
$multi_image = array();
if(!empty($node->field_image['und'])){
    $multi_image = $node->field_image['und'];
}
if (!$page):?>

    <div class="white-wrapper blog-wrapper blog-item">
        <div>
            <div class="row">
                <div class="col-md-4 col-sm-5 col-xs-12">
                    <div class="media-element entry">
                        <a href="<?php echo $node_url; ?>" title="">
                            <img src="<?php echo $image; ?>" class="img-responsive" alt="">
                            <div class="magnifier outline-outward">
                                <div class="buttons">
                                    <h3><?php print t('READ MORE');?></h3>
                                </div>
                            </div>
                        </a>

                    </div>
                </div>
                <div class="col-md-8 col-sm-7 col-xs-12">
                    <h3 class="section-sub-title">
                        <a title="" href="<?php echo $node_url; ?>"><?php echo $title; ?></a>
                    </h3>
                    <div class="post-meta">
                        <span>
                            By <?php echo $node->name; ?> <a rel="bookmark" title="Permalink to Interview: <?php echo $title; ?>" href="<?php echo $node_url; ?>">| <?php print format_date($node->created, 'custom', 'M d, Y'); ?></a>
                        </span>
                    </div><!-- end post-meta -->
                    <div class="desc">
                        <p>
                            <?php
                            if (isset($node->body['und'])) {
                                $summary = strip_tags($node->body['und'][0]['value']);
                                $summary = (strlen($summary) > 250) ? substr($summary, 0, 250) . '...' : $summary;
                                echo $summary;
                            }
                            ?>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php else:?>
    <section class="nopadding">
        <div class="row">
            <div class="col-md-9 col-sm-8 col-xs-12">
                <div class="single-post">
                    <?php if(count($multi_image) > 1):?>
                    <div id="blog-owl" class="media-element">
                        <?php foreach($multi_image as $key => $value):?>
                            <img src="<?php echo image_style_url('blog',$value['uri']); ?>" alt="" class="img-responsive">
                        <?php endforeach;?>
                    </div>
                    <?php else:?>
                    <?php if (!empty($node->field_image['und'])):?>
                    <div class="media-element">
                        <img src="<?php echo image_style_url('blog',$node->field_image['und'][0]['uri']); ?>" alt="" class="img-responsive">
                    </div><!-- end media-element -->
                    <?php endif;?>
                    <?php endif;?>

                    <h3 class="section-sub-title">
                        <?php echo $title; ?>
                    </h3><!-- end section-title -->

                    <div class="post-meta">
                        <span><a rel="author" title="View all posts by admin" href="#">by <?php echo $node->name; ?></a></span>
                        <span style="color:#bbb9af">|&nbsp;&nbsp;<a rel="bookmark" title="Permalink to Interview: <?php echo $title; ?>" href="<?php echo $node_url; ?>"> <?php print format_date($node->created, 'custom', 'M d, Y'); ?></a> &nbsp;&nbsp;|</span>
                        <span><a rel="bookmark" href="<?php print $node_url;?>#disqus_thread" data-disqus-identifier="<?php print $node->disqus['identifier']; ?>"></a></span>
                    </div><!-- end post-meta -->

                    <div class="desc">
                        <?php echo $node->body['und'][0]['value']; ?>
                    </div><!-- end desc -->

                    <div class="post-share text-left clearfix">
                        <div class="social">
                            <p>Share this:
                            <!-- Go to www.addthis.com/dashboard to customize your tools --> <div class="addthis_sharing_toolbox"></div>

                                <!--<a href="#" title="vimeo"><i class="icon-vimeo"></i></a>-->
                                <!--<a href="#" title="Behance"><i class="icon-behance"></i></a></p>-->
                        </div><!-- end social -->
                    </div><!-- end share -->

                    <div class="tags">
                        <?php print fiora_format_comma_field('field_blog_tags', $node); ?>
                    </div>

                    <hr>
                    <div class="blog-comment">
                        <?php print render($content['comments']); ?>
                    </div>


                </div><!-- end single-post -->
            </div><!-- end content -->

            <div id="sidebar" class="col-md-3 col-sm-4 col-xs-12">
                <?php
                $blog_sidebar = block_get_blocks_by_region('blog_sidebar');
                print render($blog_sidebar);
                $blog_newsletter = block_get_blocks_by_region('newsletter');
                print render($blog_newsletter);
                ?>
            </div><!-- end sidebar -->
        </div><!-- end container -->
    </section><!-- end white -->
    <div id="disqus_thread"></div>
    <?php if(isset($content['disqus'])):?>
        <?php print render($content['disqus']);?>
    <?php endif;?>
    <?php
    $bottom_content = block_get_blocks_by_region('bottom_content');
    print render($bottom_content);
    ?>
<?php endif; ?>
<script type="text/javascript" src="//s7.addthis.com/js/300/addthis_widget.js#pubid=branram"></script> 