<?php

/**
 * @file
 * Default simple view template to display a list of rows.
 *
 * @ingroup views_templates
 */

global $base_url;
$tid = '';
$name = '';
$link = '';
if(isset($view->args)){
    $tid = taxonomy_get_parents($view->args[0]);
    foreach($tid as $key => $value){
        $name = $value->name;
        $link = str_replace(" ","-",strtolower($value->name));

    }
}

if(arg(0) != 'shop'){
    $name_title = $view->build_info['substitutions']['%1'];
    $breadcrumb = array();
    $breadcrumb[] = l(t('Home'), '<front>');
    $breadcrumb[] = l(t('Products'), 'rentals');
    if(!empty($tid)){
        $breadcrumb[] = l($name, 'rentals/'.$link);
    }
    drupal_set_breadcrumb($breadcrumb);
}

?>
<div class="container">
    <div class="col-md-9 col-sm-8 col-xs-12">
        <div class="masonry_wrapper row clearfix">
            <?php foreach ($rows as $id => $row): ?>
                <?php print $row; ?>
            <?php endforeach; ?>
        </div>
    </div>
    <div id="sidebar" class="col-md-3 col-sm-4 col-xs-12">
        <?php
        $shop_sidebar = block_get_blocks_by_region('shop_sidebar');
        print render($shop_sidebar);
        ?>
    </div>
</div>