<?php

/**
 * @file
 * Admin page callbacks for the Unpublished Nodes Redirect module.
 */

/**
 * Configure unpublished_nodes_redirect settings.
 *
 * @see system_settings_form()
 */
function unpublished_nodes_redirect_admin_settings_form($form) {
  // Setup a form input for each node type.
  foreach (_unpublished_nodes_redirect_get_node_types() as $key => $type) {
    if (!$type->disabled) {
      // Fieldset.
      $form[$key] = array(
        '#type' => 'fieldset',
        '#title' => check_plain($type->name),
        '#collapsible' => TRUE,
        '#collapsed' => FALSE,
      );

      // Redirect path text input.
      $key_name = $key . '_unpublished_redirect_path';
      $form[$key][$key_name] = array(
        '#type' => 'textfield',
        '#title' => t('@type internal redirect path', array('@type' => check_plain($type->name))),
        '#description' => t('Enter an internal redirect path for the @type content type.', array('@type' => check_plain($type->name))),
        '#default_value' => variable_get($key_name, ''),
      );

      // Redirect response code.
      $key_name = $key . '_unpublished_redirect_response_code';
      $form[$key][$key_name] = array(
        '#type' => 'select',
        '#title' => t('@type response code', array('@type' => check_plain($type->name))),
        '#description' => t('Select a HTTP Response code for the redirect.'),
        '#options' => array(
          0 => t('- Please select a response code -'),
          301 => t('301 - Moved Permanently'),
          302 => t('302 - Found'),
          307 => t('307 - Temporary Redirect'),
        ),
        '#default_value' => variable_get($key_name, 0),
      );
    }
  }

  return system_settings_form($form);
}

/**
 * Validate the admin settings form.
 */
function unpublished_nodes_redirect_admin_settings_form_validate($form, &$form_state) {
  foreach (_unpublished_nodes_redirect_get_node_types() as $key => $type) {
    // Validate whether the provided redirect paths are all internal.
    $element_name = $key . '_unpublished_redirect_path';
    $submitted_redirect_path = $form_state['values'][$element_name];
    if (!empty($submitted_redirect_path) && url_is_external($submitted_redirect_path)) {
      form_set_error($element_name, t('The path provided needs to be an internal path.'));
    }

    // If a path is provided, make sure a response code is selected.
    $element_name = $key . '_unpublished_redirect_response_code';
    $submitted_response_code = $form_state['values'][$element_name];
    if (!empty($submitted_redirect_path) && $submitted_response_code == 0) {
      form_set_error($element_name, t('Please select a response code for the @type content type.', array('@type' => check_plain($type->name))));
    }
  }
}

/**
 * Helper function to get node types on the site and allow them to be altered.
 *
 * @return array
 *   The altered node types on the site.
 */
function _unpublished_nodes_redirect_get_node_types() {
  // Get all the node types on the site.
  $node_types = node_type_get_types();

  // Allow other modules to override this.
  drupal_alter('unpublished_nodes_redirect_node_types', $node_types);

  return $node_types;
}
