<?php

/**
 * @file
 * Default theme implementation for displaying search results.
 *
 * This template collects each invocation of theme_search_result(). This and
 * the child template are dependent to one another sharing the markup for
 * definition lists.
 *
 * Note that modules may implement their own search type and theme function
 * completely bypassing this template.
 *
 * Available variables:
 * - $search_results: All results as it is rendered through
 *   search-result.tpl.php
 * - $module: The machine-readable name of the module (tab) being searched, such
 *   as "node" or "user".
 *
 *
 * @see template_preprocess_search_results()
 *
 * @ingroup themeable
 */
?>
<?php if ($search_results): ?>
  <div class="row">
        <div class="col-md-9 col-sm-8 col-xs-12">
            <h2><?php print t('Search results');?></h2>
            <?php print $pager; ?>
            <div class="masonry_wrapper row clearfix">
                <?php print $search_results; ?>
            </div>
        </div>
        <div id="sidebar" class="col-md-3 col-sm-4 col-xs-12">
            <?php
            $shop_sidebar = block_get_blocks_by_region('shop_sidebar');
            print render($shop_sidebar);
            ?>
        </div>
  </div>

<?php else : ?>
  <h2><?php print t('Your search yielded no results');?></h2>
  <?php print search_help('search#noresults', drupal_help_arg()); ?>
<?php endif; ?>

